# 🚀 AviaCoin Presale Website

## 📋 Описание

AviaCoin Presale - это современная платформа для проведения presale токенов на блокчейне Solana с поддержкой различных wallet'ов.

## ✨ Возможности

- 🔗 **Поддержка wallet'ов**: Phantom, Trust Wallet, WalletConnect
- 💱 **Гибкий ввод**: SOL или US7 токены
- 📊 **Прогресс-бар**: Отслеживание сбора средств
- 🎨 **Современный UI**: Адаптивный дизайн с анимациями
- 💾 **Persistent data**: Сохранение прогресса в localStorage

## 🛠️ Технологии

- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Blockchain**: Solana Web3.js
- **Libraries**: QRCode Generator, WalletConnect
- **Styling**: Custom CSS с анимациями

## 📁 Структура файлов

```
/
├── index.html      # Главная страница
├── styles.css      # Стили и анимации
├── app.js         # Основная логика приложения
├── config.js      # Конфигурация presale
└── logo.jpg       # Логотип проекта
```

## 🚀 Развертывание

### Требования

- Веб-сервер (Apache, Nginx, или любой static hosting)
- HTTPS поддержка (обязательно для wallet'ов)
- Доступ к Solana RPC

### Быстрое развертывание

1. **Загрузите файлы** на ваш хостинг
2. **Убедитесь в HTTPS** - wallet'ы требуют защищенное соединение
3. **Настройте config.js** под ваш проект

### Настройка config.js

```javascript
const PRESALE_CONFIG = {
    targetAmount: 1000,           // Цель сбора в SOL
    raisedAmount: 0,             // Начальные средства (автоматически обновляется)
    participants: 0,             // Количество участников
    endDate: '2026-01-31T23:59', // Дата окончания
    receivingWallet: 'ВАШ_SOLANA_АДРЕС', // Кошелек для приема средств
    walletConnectProjectId: 'ВАШ_PROJECT_ID', // WalletConnect ID
    exchangeRate: 128            // Курс: 1 SOL = 128 US7
};
```

## 🔐 Безопасность

- ✅ **HTTPS обязательна** для работы wallet'ов
- ✅ **CSP headers** настроены
- ✅ **Input validation** на всех формах
- ✅ **Secure wallet connections**

## 📱 Поддерживаемые устройства

- ✅ **Desktop**: Chrome, Firefox, Edge, Safari
- ✅ **Mobile**: iOS Safari, Android Chrome
- ✅ **Tablet**: Все современные планшеты

## 🐛 Устранение проблем

### Phantom не подключается
- Убедитесь, что сайт на HTTPS
- Проверьте установку расширения Phantom
- Попробуйте перезагрузить страницу

### QR код не сканируется
- Проверьте подключение к интернету
- Попробуйте другой QR сканер
- Убедитесь в правильности WalletConnect URI

### Прогресс не сохраняется
- Проверьте, включен ли localStorage
- Очистите кэш браузера
- Проверьте на приватном режиме

## 📞 Поддержка

Для технической поддержки или вопросов по настройке обращайтесь к разработчикам.

## 📄 Лицензия

Все права защищены. © 2024 AviaCoin Team.
