// Presale Configuration File
// Edit these values to customize your presale

const PRESALE_CONFIG = {
    // Target amount in SOL
    targetAmount: 1000,

    // Current raised amount in SOL (will be updated automatically)
    raisedAmount: 0,

    // Number of participants (will be updated automatically)
    participants: 0,

    // End date (YYYY-MM-DDTHH:MM format)
    endDate: '2026-01-31T23:59',

    // Wallet addresses
    receivingWallet: 'HmDSN72PGjwUMwMFm8KVboUfPZSD4XMFXSS4BHoV7VC8',

    // WalletConnect Project ID
    walletConnectProjectId: 'fb6ef5ab35c64bde0f3f9574c97b3c31',

    // Token Exchange Rate (US7 tokens per 1 SOL)
    exchangeRate: 128,

    // UI Settings
    title: '🚀 Solana Token Presale',
    subtitle: 'Join the revolution on Solana blockchain',

    // Features list
    features: [
        'Lightning-fast transactions on Solana',
        'Low fees and high scalability',
        'Exclusive community access',
        'Potential for massive growth'
    ]
};

// Export for use in other files
if (typeof module !== 'undefined' && module.exports) {
    module.exports = PRESALE_CONFIG;
}
