import { EventEmitter } from "events";
import { Logger } from "@walletconnect/logger";
import { IRelayer, ISubscriber, SubscriberTypes } from "@walletconnect/types";
import { SubscriberTopicMap } from "./topicmap.js";
export declare class Subscriber extends ISubscriber {
    relayer: IRelayer;
    logger: Logger;
    subscriptions: Map<string, SubscriberTypes.Active>;
    topicMap: SubscriberTopicMap;
    events: EventEmitter<[never]>;
    name: string;
    version: string;
    pending: Map<string, SubscriberTypes.Params>;
    private cached;
    private initialized;
    private storagePrefix;
    private subscribeTimeout;
    private initialSubscribeTimeout;
    private clientId;
    private batchSubscribeTopicsLimit;
    constructor(relayer: IRelayer, logger: Logger);
    init: ISubscriber["init"];
    get context(): string;
    get storageKey(): string;
    get length(): number;
    get ids(): string[];
    get values(): SubscriberTypes.Active[];
    get topics(): string[];
    get hasAnyTopics(): boolean;
    subscribe: ISubscriber["subscribe"];
    unsubscribe: ISubscriber["unsubscribe"];
    isSubscribed: ISubscriber["isSubscribed"];
    isKnownTopic: ISubscriber["isKnownTopic"];
    on: ISubscriber["on"];
    once: ISubscriber["once"];
    off: ISubscriber["off"];
    removeListener: ISubscriber["removeListener"];
    start: ISubscriber["start"];
    stop: ISubscriber["stop"];
    private hasSubscription;
    private reset;
    private onDisable;
    private unsubscribeByTopic;
    private unsubscribeById;
    private rpcSubscribe;
    private rpcBatchSubscribe;
    private rpcBatchFetchMessages;
    private rpcUnsubscribe;
    private onSubscribe;
    private onBatchSubscribe;
    private onUnsubscribe;
    private setRelayerSubscriptions;
    private getRelayerSubscriptions;
    private setSubscription;
    private addSubscription;
    private getSubscription;
    private deleteSubscription;
    private restart;
    private persist;
    private onRestart;
    private restore;
    private batchSubscribe;
    private batchFetchMessages;
    private onConnect;
    private onDisconnect;
    private checkPending;
    private registerEventListeners;
    private isInitialized;
    private restartToComplete;
    private getClientId;
    private getSubscriptionId;
}
//# sourceMappingURL=subscriber.d.ts.map