import { IEngine } from "@walletconnect/types";
export declare class Engine extends IEngine {
    name: string;
    private events;
    private initialized;
    private requestQueue;
    private sessionRequestQueue;
    private emittedSessionRequests;
    private requestQueueDelay;
    private expectedPairingMethodMap;
    private recentlyDeletedMap;
    private recentlyDeletedLimit;
    private relayMessageCache;
    private pendingSessions;
    constructor(client: IEngine["client"]);
    init: IEngine["init"];
    private processPendingMessageEvents;
    connect: IEngine["connect"];
    pair: IEngine["pair"];
    approve: IEngine["approve"];
    reject: IEngine["reject"];
    update: IEngine["update"];
    extend: IEngine["extend"];
    request: IEngine["request"];
    respond: IEngine["respond"];
    ping: IEngine["ping"];
    emit: IEngine["emit"];
    disconnect: IEngine["disconnect"];
    find: IEngine["find"];
    getPendingSessionRequests: IEngine["getPendingSessionRequests"];
    authenticate: IEngine["authenticate"];
    approveSessionAuthenticate: IEngine["approveSessionAuthenticate"];
    rejectSessionAuthenticate: IEngine["rejectSessionAuthenticate"];
    formatAuthMessage: IEngine["formatAuthMessage"];
    processRelayMessageCache: IEngine["processRelayMessageCache"];
    private cleanupDuplicatePairings;
    private deleteSession;
    private deleteProposal;
    private deletePendingSessionRequest;
    private deletePendingAuthRequest;
    private setExpiry;
    private setProposal;
    private setAuthRequest;
    private setPendingSessionRequest;
    private sendRequest;
    private sendProposeSession;
    private sendApproveSession;
    private sendResult;
    private sendError;
    private cleanup;
    private isInitialized;
    private confirmOnlineStateOrThrow;
    private registerRelayerEvents;
    private onProviderMessageEvent;
    private onRelayMessage;
    private onRelayEventRequest;
    private processRequestsQueue;
    private processRequest;
    private onRelayEventResponse;
    private onRelayEventUnknownPayload;
    private shouldIgnorePairingRequest;
    private onSessionProposeRequest;
    private onSessionProposeResponse;
    private onSessionSettleRequest;
    private onSessionSettleResponse;
    private onSessionUpdateRequest;
    private isRequestOutOfSync;
    private onSessionUpdateResponse;
    private onSessionExtendRequest;
    private onSessionExtendResponse;
    private onSessionPingRequest;
    private onSessionPingResponse;
    private onSessionDeleteRequest;
    private onSessionRequest;
    private onSessionRequestResponse;
    private onSessionEventRequest;
    private onSessionAuthenticateResponse;
    private onSessionAuthenticateRequest;
    private addSessionRequestToSessionRequestQueue;
    private cleanupAfterResponse;
    private cleanupPendingSentRequestsForTopic;
    private processSessionRequestQueue;
    private emitSessionRequest;
    private registerExpirerEvents;
    private registerPairingEvents;
    private onPairingCreated;
    private isValidPairingTopic;
    private isValidSessionTopic;
    private isValidSessionOrPairingTopic;
    private isValidProposalId;
    private isValidConnect;
    private validateNamespaces;
    private isValidApprove;
    private isValidReject;
    private isValidSessionSettleRequest;
    private isValidUpdate;
    private isValidExtend;
    private isValidRequest;
    private validateRequestExpiry;
    private isValidRespond;
    private isValidPing;
    private isValidEmit;
    private isValidDisconnect;
    private isValidAuthenticate;
    private getVerifyContext;
    private validateSessionProps;
    private getPendingAuthRequest;
    private addToRecentlyDeleted;
    private checkRecentlyDeleted;
    private isLinkModeEnabled;
    private getAppLinkIfEnabled;
    private handleLinkModeMessage;
    private registerLinkModeListeners;
    private getTVFApproveParams;
    private getTVFParams;
    private isValidContractData;
    private extractTxHashesFromResult;
}
//# sourceMappingURL=engine.d.ts.map