import { SignClientTypes, RelayerClientMetadata, EngineTypes, RelayerTypes } from "@walletconnect/types";
import { ErrorResponse } from "@walletconnect/jsonrpc-utils";
import { IKeyValueStorage } from "@walletconnect/keyvaluestorage";
export declare const REACT_NATIVE_PRODUCT = "ReactNative";
export declare const ENV_MAP: {
    reactNative: string;
    node: string;
    browser: string;
    unknown: string;
};
export declare const EMPTY_SPACE = " ";
export declare const COLON = ":";
export declare const SLASH = "/";
export declare const DEFAULT_DEPTH = 2;
export declare const ONE_THOUSAND = 1000;
export declare const SDK_TYPE = "js";
export declare function isNode(): boolean;
export declare function isReactNative(): boolean;
export declare function isAndroid(): boolean;
export declare function isIos(): boolean;
export declare function isBrowser(): boolean;
export declare function getEnvironment(): string;
export declare function getAppId(): string | undefined;
export declare function appendToQueryString(queryString: string, newQueryParams: Record<string, string | number | boolean | undefined>): string;
export declare function populateAppMetadata(metadata?: SignClientTypes.Metadata): SignClientTypes.Metadata;
export declare function getAppMetadata(): SignClientTypes.Metadata;
export declare function getRelayClientMetadata(protocol: string, version: number): RelayerClientMetadata;
export declare function getJavascriptOS(): string;
export declare function getJavascriptID(): string;
export declare function formatUA(protocol: string, version: number, sdkVersion: string): string;
export declare function formatRelayRpcUrl({ protocol, version, relayUrl, sdkVersion, auth, projectId, useOnCloseEvent, bundleId, packageName, }: RelayerTypes.RpcUrlParams): string;
export declare function getHttpUrl(url: string): string;
export declare function assertType(obj: any, key: string, type: string): void;
export declare function parseContextNames(context: string, depth?: number): any[];
export declare function formatMessageContext(context: string): string;
export declare function hasOverlap(a: any[], b: any[]): boolean;
export declare function getLastItems(arr: any[], depth?: number): any[];
export declare function mapToObj<T = any>(map: Map<string, T>): Record<string, T>;
export declare function objToMap<T = any>(obj: Record<string, T>): Map<string, T>;
export declare function mapEntries<A = any, B = any>(obj: Record<string, A>, cb: (x: A) => B): Record<string, B>;
export declare const enumify: <T extends {
    [index: string]: U;
}, U extends string>(x: T) => T;
export declare function capitalizeWord(word: string): string;
export declare function capitalize(str: string): string;
export declare function createDelayedPromise<T>(expiry?: number, expireErrorMessage?: string): {
    resolve: (value?: T) => void;
    reject: (value?: ErrorResponse) => void;
    done: () => Promise<T>;
};
export declare function createExpiringPromise<T>(promise: Promise<T>, expiry: number, expireErrorMessage?: string): Promise<unknown>;
export declare function formatExpirerTarget(type: "topic" | "id", value: string | number): string;
export declare function formatTopicTarget(topic: string): string;
export declare function formatIdTarget(id: number): string;
export declare function parseExpirerTarget(target: string): {
    id?: number;
    topic?: string;
};
export declare function calcExpiry(ttl: number, now?: number): number;
export declare function isExpired(expiry: number): boolean;
export declare function engineEvent(event: EngineTypes.Event, id?: number | string | undefined): string;
export declare function mergeArrays<T>(a?: T[], b?: T[]): T[];
export declare function handleDeeplinkRedirect({ id, topic, wcDeepLink, }: {
    id: number;
    topic: string;
    wcDeepLink: string;
}): Promise<void>;
export declare function formatDeeplinkUrl(deeplink: string, requestId: number, sessionTopic: string): string;
export declare function openDeeplink(url: string): void;
export declare function getDeepLink(storage: IKeyValueStorage, key: string): Promise<string | undefined>;
export declare function getCommonValuesInArrays<T = string | number | boolean>(arr1: T[], arr2: T[]): T[];
export declare function getSearchParamFromURL(url: string, param: any): string | null;
export declare function uuidv4(): string;
export declare function isTestRun(): boolean;
export declare function isTelegram(): boolean;
export declare function isIframe(): boolean;
export declare function toBase64(input: string, removePadding?: boolean): string;
export declare function fromBase64(encodedString: string): string;
export declare function sleep(ms: number): Promise<unknown>;
export declare class LimitedSet<T> {
    private limit;
    private set;
    constructor({ limit }: {
        limit: number;
    });
    add(item: T): void;
    has(item: T): boolean;
}
//# sourceMappingURL=misc.d.ts.map