/** @see https://github.com/ethereum/EIPs/blob/master/EIPS/eip-4844.md#parameters */
export const versionedHashVersion = 1;
/**
 * Defines a KZG interface.
 *
 * @example
 * ```ts twoslash
 * // @noErrors
 * import * as cKzg from 'c-kzg'
 * import { Kzg } from 'ox'
 * import { Paths } from 'ox/trusted-setups'
 *
 * cKzg.loadTrustedSetup(Paths.mainnet)
 *
 * const kzg = Kzg.from(cKzg)
 * ```
 *
 * @param value - The KZG object to convert.
 * @returns The KZG interface object.
 */
export function from(value) {
    const { blobToKzgCommitment, computeBlobKzgProof } = value;
    return {
        blobToKzgCommitment,
        computeBlobKzgProof,
    };
}
//# sourceMappingURL=Kzg.js.map